/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.SaveRestoreBean;
import com.ibm.hwmca.base.saverest.SaveRestoreConstants;
import com.ibm.hwmca.base.saverest.SaveRestoreErrorIds;
import com.ibm.hwmca.base.saverest.SaveRestoreUtil;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class SaveRestoreTasklet
extends PanelTasklet
implements SaveRestoreConstants,
SaveRestoreErrorIds {
    private static final String TRACE_MASKT = "XSRDAPPT";
    private static final String TRACE_MASKF = "XSRDAPPF";
    private static final String TRACE_MASKD = "XSRDAPPD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(37, "SaveRestCustData");
    private SaveRestoreUtil saveRestoreUtil;

    public void logException(Throwable throwable) {
        new FrameworkLog(_logInfo, 1, throwable).log();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> SaveRestoreTasklet.service()");
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKT, "-> SaveRestoreTasklet.init()");
            this.saveRestoreUtil = new SaveRestoreUtil();
            SaveRestoreBean bean = new SaveRestoreBean();
            bean.setBeanName("SaveRestBean");
            String[][] info = this.saveRestoreUtil.getItemDescriptorRawData();
            bean.setItemDescriptorInfo(info[0], info[1]);
            response.replace("com.ibm.hwmca.base.saverest.res.SaveRestoreRes", "SaveRestorePanel", bean);
            Trace.trace(TRACE_MASKT, "<- SaveRestoreTasklet.init()");
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKT, "Terminating the tasklet");
            response.terminate();
        } else {
            String command = (String)request.getData("event");
            Trace.trace(TRACE_MASKF, "SaveRestoreTasklet.service: " + command);
            String[] selectedItems = (String[])request.getData("items");
            String fileName = (String)request.getData("filename");
            if (command.equals("SaveButton")) {
                try {
                    if (this.messageBoxYesNo("xsrd.ques.save", null)) {
                        this.saveRestoreUtil.saveItems(selectedItems, fileName);
                        this.messageBoxOK("xsrd.file.saved.to", new String[]{fileName});
                    }
                }
                catch (HException he) {
                    Trace.trace(TRACE_MASKF, "Exception in save");
                    this.messageBoxOK("xsrd.error.saving", null);
                }
                response.noAction();
            } else if (command.equals("RestoreButton")) {
                if (this.saveRestoreUtil.restoreItemsWarningCheck(selectedItems)) {
                    this.showMessageBox(true, new BaseMessageTitle("DATAREP6.TITLE"), new BaseMessageText("DATAREP9"), null, null);
                } else {
                    try {
                        if (this.messageBoxYesNo("xsrd.ques.restore", null)) {
                            this.saveRestoreUtil.restoreItems(selectedItems, fileName);
                            this.messageBoxOK("xsrd.data.restored.from", new String[]{fileName});
                        }
                    }
                    catch (HException he) {
                        Trace.trace(TRACE_MASKF, "Exception in restore");
                        this.messageBoxOK("xsrd.error.restoring", null);
                    }
                }
                response.noAction();
            } else if (command.equals("LocalModeItem")) {
                response.noAction();
            } else if (command.equals("NetworkModeItem")) {
                response.redirect("com.ibm.hwmca.base.saverest.cloning.CloningTasklet");
            } else if (command.equals("ConfigureItem")) {
                response.openModalChild(new DisplayAreaDescriptorDelegate("com.ibm.hwmca.base.saverest.cloning.CloningSettingsTasklet", null));
            } else if (command.equals("showMessage")) {
                String msgid = (String)request.getData("showMessage");
                if (msgid == null) {
                    response.error(new LocalizableText("Unknown state!  No message to display"), command);
                } else {
                    String[] args = (String[])request.getData("showMessage_args");
                    this.messageBoxOK(msgid, args);
                    response.noAction();
                }
            } else {
                Trace.trace(TRACE_MASKF, "Unknown state!");
                Trace.trace(TRACE_MASKF, "Command: " + command);
                response.error(new LocalizableText("Unknown state!"), command);
            }
        }
    }

    void messageBoxOK(String message, String[] subst) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> SaveRestoreTasklet.messageBoxOK(" + message + "," + subst + ")");
        MessageText mt = new MessageText("com.ibm.hwmca.base.saverest.res.saveresttext", message, subst);
        this.showMessageBox(true, this.presentationTaskParms.getUIInfo().getUnlocalizedName(), new MessageText[]{mt}, mt.getMsgId(), mt.getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.ok")});
        Trace.trace(TRACE_MASKF, "<- SaveRestoreTasklet.messageBoxOK()");
    }

    boolean messageBoxYesNo(String message, String[] subst) throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> SaveRestoreTasklet.messageBoxYesNo(" + message + "," + subst + ")");
        MessageText mt = new MessageText("com.ibm.hwmca.base.saverest.res.saveresttext", message, subst);
        LocalizableText ans = this.showMessageBox(true, this.presentationTaskParms.getUIInfo().getUnlocalizedName(), new MessageText[]{mt}, mt.getMsgId(), mt.getMsgType(), new LocalizableText[]{new LocalizableText("com/ibm/hwmca/fw/res/common", "button.yes"), new LocalizableText("com/ibm/hwmca/fw/res/common", "button.no")});
        boolean bAns = true;
        bAns = ans != null && !ans.equals(new LocalizableText("com/ibm/hwmca/fw/res/common", "button.no"));
        Trace.trace(TRACE_MASKF, "<- SaveRestoreTasklet.messageBoxYesNo(" + bAns + ")");
        return bAns;
    }
}

